package org.kodein.emoji.animals_nature.plant_other

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LeafFlutteringInWind: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍃",
        description = "leaf fluttering in wind",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("leaf-fluttering-in-wind", "leaves"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Animals & Nature: plant-other: leaf fluttering in wind.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LeafFlutteringInWind: Emoji get() = _LeafFlutteringInWind

/**
 * Alias to emoji [LeafFlutteringInWind] (Animals & Nature: plant-other: leaf fluttering in wind).
*/
public val Emoji.Companion.Leaves: Emoji get() = _LeafFlutteringInWind
