package org.kodein.emoji.people_body.hands

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHands() {
    add(intArrayOf(0x1f44f), _ClappingHands)
    addVariations(intArrayOf(0x1f44f, 0x0), _ClappingHands, 1)
    add(intArrayOf(0x1faf6), _HeartHands)
    addVariations(intArrayOf(0x1faf6, 0x0), _HeartHands, 1)
    add(intArrayOf(0x1f64c), _RaisingHands)
    addVariations(intArrayOf(0x1f64c, 0x0), _RaisingHands, 1)
    add(intArrayOf(0x1f450), _OpenHands)
    addVariations(intArrayOf(0x1f450, 0x0), _OpenHands, 1)
    add(intArrayOf(0x1f932), _PalmsUpTogether)
    addVariations(intArrayOf(0x1f932, 0x0), _PalmsUpTogether, 1)
    add(intArrayOf(0x1f91d), _Handshake)
    addVariations(intArrayOf(0x1f91d, 0x0), _Handshake, 1)
    addVariations(intArrayOf(0x1faf1, 0x0, 0x200d, 0x1faf2, 0x0), _Handshake, 1, 4)
    add(intArrayOf(0x1f64f), _FoldedHands)
    addVariations(intArrayOf(0x1f64f, 0x0), _FoldedHands, 1)
}

internal fun MutableList<Emoji>.addAllHands() {
    add(_ClappingHands)
    add(_HeartHands)
    add(_RaisingHands)
    add(_OpenHands)
    add(_PalmsUpTogether)
    add(_Handshake)
    add(_FoldedHands)
}

/**
 * All Emoji of the People & Body: hands subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allHands(): List<Emoji> =
    ArrayList<Emoji>(7).apply { addAllHands() }
