package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _IdButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🆔",
        description = "ID button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("id-button", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: ID button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.IdButton: Emoji get() = _IdButton
