package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Information: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "ℹ️",
        description = "information",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("information", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: information.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Information: Emoji get() = _Information
