package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BlueSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟦",
        description = "blue square",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("blue-square", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: blue square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BlueSquare: Emoji get() = _BlueSquare
