package org.kodein.emoji.symbols.math

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Minus: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "➖",
        description = "minus",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("minus", "minus-sign", "-"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: math: minus.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Minus: Emoji get() = _Minus

/**
 * Alias to emoji [Minus] (Symbols: math: minus).
*/
public val Emoji.Companion.MinusSign: Emoji get() = _Minus
