package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCostaRica: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇷",
        description = "flag: Costa Rica",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-costa-rica", "costa-rica-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Costa Rica.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCostaRica: Emoji get() = _FlagCostaRica

/**
 * Alias to emoji [FlagCostaRica] (Flags: country-flag: flag: Costa Rica).
*/
public val Emoji.Companion.CostaRicaFlag: Emoji get() = _FlagCostaRica
