package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMontenegro: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇪",
        description = "flag: Montenegro",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-montenegro", "montenegro-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Montenegro.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMontenegro: Emoji get() = _FlagMontenegro

/**
 * Alias to emoji [FlagMontenegro] (Flags: country-flag: flag: Montenegro).
*/
public val Emoji.Companion.MontenegroFlag: Emoji get() = _FlagMontenegro
