package org.kodein.emoji.objects.computer

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ComputerMouse: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🖱️",
        description = "computer mouse",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("computer-mouse", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: computer: computer mouse.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ComputerMouse: Emoji get() = _ComputerMouse
