package org.kodein.emoji.objects.money

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MoneyBag: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💰",
        description = "money bag",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("money-bag", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: money: money bag.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MoneyBag: Emoji get() = _MoneyBag
