package org.kodein.emoji.people_body.hand_prop

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _NailPolish: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "💅",
        description = "nail polish",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("nail-polish", "nail-care"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-prop: nail polish.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NailPolish: SkinTone1Emoji get() = _NailPolish

/**
 * Alias to emoji [NailPolish] (People & Body: hand-prop: nail polish).
*/
public val Emoji.Companion.NailCare: SkinTone1Emoji get() = _NailPolish
