package org.kodein.emoji.people_body.person

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonRedHair: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧑‍🦰",
        description = "person: red hair",
        unicodeVersion = UnicodeVersion(12, 1),
        aliases = listOf("person-red-hair", "red-hair"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person: person: red hair.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonRedHair: SkinTone1Emoji get() = _PersonRedHair

/**
 * Alias to emoji [PersonRedHair] (People & Body: person: person: red hair).
*/
public val Emoji.Companion.RedHair: SkinTone1Emoji get() = _PersonRedHair
