package org.kodein.emoji.people_body.person_role

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _OfficeWorker: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧑‍💼",
        description = "office worker",
        unicodeVersion = UnicodeVersion(12, 1),
        aliases = listOf("office-worker", "business-person"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-role: office worker.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OfficeWorker: SkinTone1Emoji get() = _OfficeWorker

/**
 * Alias to emoji [OfficeWorker] (People & Body: person-role: office worker).
*/
public val Emoji.Companion.BusinessPerson: SkinTone1Emoji get() = _OfficeWorker
