package org.kodein.emoji.smileys_emotion.face_hat

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CowboyHatFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤠",
        description = "cowboy hat face",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("cowboy-hat-face", "cowboy"),
        emoticons = listOf("<):)"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-hat: cowboy hat face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CowboyHatFace: Emoji get() = _CowboyHatFace

/**
 * Alias to emoji [CowboyHatFace] (Smileys & Emotion: face-hat: cowboy hat face).
*/
public val Emoji.Companion.Cowboy: Emoji get() = _CowboyHatFace
