package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GrinningFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😀",
        description = "grinning face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("grinning-face", "smile"),
        emoticons = listOf(":D"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: grinning face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GrinningFace: Emoji get() = _GrinningFace

/**
 * Alias to emoji [GrinningFace] (Smileys & Emotion: face-smiling: grinning face).
*/
public val Emoji.Companion.Smile: Emoji get() = _GrinningFace
