package org.kodein.emoji.smileys_emotion.monkey_face

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllMonkeyFace() {
    add(intArrayOf(0x1f648), _SeeNoEvilMonkey)
    add(intArrayOf(0x1f649), _HearNoEvilMonkey)
    add(intArrayOf(0x1f64a), _SpeakNoEvilMonkey)
}

internal fun MutableList<Emoji>.addAllMonkeyFace() {
    add(_SeeNoEvilMonkey)
    add(_HearNoEvilMonkey)
    add(_SpeakNoEvilMonkey)
}

/**
 * All Emoji of the Smileys & Emotion: monkey-face subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allMonkeyFace(): List<Emoji> =
    ArrayList<Emoji>(3).apply { addAllMonkeyFace() }
