package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Keycap1: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "1️⃣",
        description = "keycap: 1",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("keycap-1", "one", "keycap-one"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: 1.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Keycap1: Emoji get() = _Keycap1

/**
 * Alias to emoji [Keycap1] (Symbols: keycap: keycap: 1).
*/
public val Emoji.Companion.One: Emoji get() = _Keycap1

/**
 * Alias to emoji [Keycap1] (Symbols: keycap: keycap: 1).
*/
public val Emoji.Companion.KeycapOne: Emoji get() = _Keycap1
