package org.kodein.emoji.symbols.punctuation

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RedQuestionMark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "❓",
        description = "red question mark",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("red-question-mark", "question", "question-mark", "-"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: punctuation: red question mark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RedQuestionMark: Emoji get() = _RedQuestionMark

/**
 * Alias to emoji [RedQuestionMark] (Symbols: punctuation: red question mark).
*/
public val Emoji.Companion.Question: Emoji get() = _RedQuestionMark

/**
 * Alias to emoji [RedQuestionMark] (Symbols: punctuation: red question mark).
*/
public val Emoji.Companion.QuestionMark: Emoji get() = _RedQuestionMark
