package org.kodein.emoji.symbols.warning

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NoBicycles: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚳",
        description = "no bicycles",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("no-bicycles", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: warning: no bicycles.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NoBicycles: Emoji get() = _NoBicycles
