package org.kodein.emoji.travel_places.place_map

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPlaceMap() {
    add(intArrayOf(0x1f30d), _GlobeShowingEuropeAfrica)
    add(intArrayOf(0x1f30e), _GlobeShowingAmericas)
    add(intArrayOf(0x1f30f), _GlobeShowingAsiaAustralia)
    add(intArrayOf(0x1f9ed), _Compass)
    add(intArrayOf(0x1f5fe), _MapOfJapan)
    add(intArrayOf(0x1f5fa, 0xfe0f), _WorldMap)
    add(intArrayOf(0x1f5fa), _WorldMap)
    add(intArrayOf(0x1f310), _GlobeWithMeridians)
}

internal fun MutableList<Emoji>.addAllPlaceMap() {
    add(_GlobeShowingEuropeAfrica)
    add(_GlobeShowingAmericas)
    add(_GlobeShowingAsiaAustralia)
    add(_Compass)
    add(_MapOfJapan)
    add(_WorldMap)
    add(_GlobeWithMeridians)
}

/**
 * All Emoji of the Travel & Places: place-map subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allPlaceMap(): List<Emoji> =
    ArrayList<Emoji>(7).apply { addAllPlaceMap() }
