package org.kodein.emoji.animals_nature.plant_flower

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPlantFlower() {
    add(intArrayOf(0x1f490), _Bouquet)
    add(intArrayOf(0x1f339), _Rose)
    add(intArrayOf(0x1f940), _WiltedFlower)
    add(intArrayOf(0x1f33a), _Hibiscus)
    add(intArrayOf(0x1f337), _Tulip)
    add(intArrayOf(0x1fab7), _Lotus)
    add(intArrayOf(0x1f338), _CherryBlossom)
    add(intArrayOf(0x1f4ae), _WhiteFlower)
    add(intArrayOf(0x1f3f5, 0xfe0f), _Rosette)
    add(intArrayOf(0x1f3f5), _Rosette)
    add(intArrayOf(0x1fabb), _Hyacinth)
    add(intArrayOf(0x1f33b), _Sunflower)
    add(intArrayOf(0x1f33c), _Blossom)
}

internal fun MutableList<Emoji>.addAllPlantFlower() {
    add(_Bouquet)
    add(_Rose)
    add(_WiltedFlower)
    add(_Hibiscus)
    add(_Tulip)
    add(_Lotus)
    add(_CherryBlossom)
    add(_WhiteFlower)
    add(_Rosette)
    add(_Hyacinth)
    add(_Sunflower)
    add(_Blossom)
}

/**
 * All Emoji of the Animals & Nature: plant-flower subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allPlantFlower(): List<Emoji> =
    ArrayList<Emoji>(12).apply { addAllPlantFlower() }
