package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBahamas: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇸",
        description = "flag: Bahamas",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-bahamas", "bahamas-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Bahamas.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBahamas: Emoji get() = _FlagBahamas

/**
 * Alias to emoji [FlagBahamas] (Flags: country-flag: flag: Bahamas).
*/
public val Emoji.Companion.BahamasFlag: Emoji get() = _FlagBahamas
