package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagJordan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇯🇴",
        description = "flag: Jordan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-jordan", "jordan-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Jordan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagJordan: Emoji get() = _FlagJordan

/**
 * Alias to emoji [FlagJordan] (Flags: country-flag: flag: Jordan).
*/
public val Emoji.Companion.JordanFlag: Emoji get() = _FlagJordan
