package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagKiribati: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇰🇮",
        description = "flag: Kiribati",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-kiribati", "kiribati-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Kiribati.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagKiribati: Emoji get() = _FlagKiribati

/**
 * Alias to emoji [FlagKiribati] (Flags: country-flag: flag: Kiribati).
*/
public val Emoji.Companion.KiribatiFlag: Emoji get() = _FlagKiribati
