package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTuRkiye: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇷",
        description = "flag: Türkiye",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-tu-rkiye", "turkey-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Türkiye.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTuRkiye: Emoji get() = _FlagTuRkiye

/**
 * Alias to emoji [FlagTuRkiye] (Flags: country-flag: flag: Türkiye).
*/
public val Emoji.Companion.TurkeyFlag: Emoji get() = _FlagTuRkiye
