package org.kodein.emoji.objects.light_video

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LightBulb: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💡",
        description = "light bulb",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("light-bulb", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Objects: light & video: light bulb.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LightBulb: Emoji get() = _LightBulb
