package org.kodein.emoji.objects.money

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PoundBanknote: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💷",
        description = "pound banknote",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("pound-banknote", "pound"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: money: pound banknote.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PoundBanknote: Emoji get() = _PoundBanknote

/**
 * Alias to emoji [PoundBanknote] (Objects: money: pound banknote).
*/
public val Emoji.Companion.Pound: Emoji get() = _PoundBanknote
