package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllOffice() {
    add(intArrayOf(0x1f4bc), _Briefcase)
    add(intArrayOf(0x1f4ce), _Paperclip)
    add(intArrayOf(0x1f587, 0xfe0f), _LinkedPaperclips)
    add(intArrayOf(0x1f587), _LinkedPaperclips)
    add(intArrayOf(0x1f4cf), _StraightRuler)
    add(intArrayOf(0x1f4d0), _TriangularRuler)
    add(intArrayOf(0x1f5d2, 0xfe0f), _SpiralNotepad)
    add(intArrayOf(0x1f5d2), _SpiralNotepad)
    add(intArrayOf(0x1f4cb), _Clipboard)
    add(intArrayOf(0x1f4c2), _OpenFileFolder)
    add(intArrayOf(0x1f4c1), _FileFolder)
    add(intArrayOf(0x1f5c2, 0xfe0f), _CardIndexDividers)
    add(intArrayOf(0x1f5c2), _CardIndexDividers)
    add(intArrayOf(0x1f5c3, 0xfe0f), _CardFileBox)
    add(intArrayOf(0x1f5c3), _CardFileBox)
    add(intArrayOf(0x1f5c4, 0xfe0f), _FileCabinet)
    add(intArrayOf(0x1f5c4), _FileCabinet)
    add(intArrayOf(0x1f4ca), _BarChart)
    add(intArrayOf(0x1f4c8), _ChartIncreasing)
    add(intArrayOf(0x1f4c9), _ChartDecreasing)
    add(intArrayOf(0x1f4c7), _CardIndex)
    add(intArrayOf(0x1f4cc), _Pushpin)
    add(intArrayOf(0x1f4cd), _RoundPushpin)
    add(intArrayOf(0x2702, 0xfe0f), _Scissors)
    add(intArrayOf(0x2702), _Scissors)
    add(intArrayOf(0x1f5d1, 0xfe0f), _Wastebasket)
    add(intArrayOf(0x1f5d1), _Wastebasket)
    add(intArrayOf(0x1f4c5), _Calendar)
    add(intArrayOf(0x1f4c6), _TearOffCalendar)
    add(intArrayOf(0x1f5d3, 0xfe0f), _SpiralCalendar)
    add(intArrayOf(0x1f5d3), _SpiralCalendar)
}

internal fun MutableList<Emoji>.addAllOffice() {
    add(_Briefcase)
    add(_Paperclip)
    add(_LinkedPaperclips)
    add(_StraightRuler)
    add(_TriangularRuler)
    add(_SpiralNotepad)
    add(_Clipboard)
    add(_OpenFileFolder)
    add(_FileFolder)
    add(_CardIndexDividers)
    add(_CardFileBox)
    add(_FileCabinet)
    add(_BarChart)
    add(_ChartIncreasing)
    add(_ChartDecreasing)
    add(_CardIndex)
    add(_Pushpin)
    add(_RoundPushpin)
    add(_Scissors)
    add(_Wastebasket)
    add(_Calendar)
    add(_TearOffCalendar)
    add(_SpiralCalendar)
}

/**
 * All Emoji of the Objects: office subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allOffice(): List<Emoji> =
    ArrayList<Emoji>(23).apply { addAllOffice() }
