package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CarpentrySaw: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪚",
        description = "carpentry saw",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("carpentry-saw", "saw"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: tool: carpentry saw.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CarpentrySaw: Emoji get() = _CarpentrySaw

/**
 * Alias to emoji [CarpentrySaw] (Objects: tool: carpentry saw).
*/
public val Emoji.Companion.Saw: Emoji get() = _CarpentrySaw
