package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FamilyWomanBoy: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👩‍👦",
        description = "family: woman, boy",
        unicodeVersion = UnicodeVersion(4, 0),
        aliases = listOf("family-woman-boy", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji People & Body: family: family: woman, boy.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FamilyWomanBoy: Emoji get() = _FamilyWomanBoy
