package org.kodein.emoji.people_body.hand_fingers_open

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _WavingHand: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "👋",
        description = "waving hand",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("waving-hand", "wave"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-open: waving hand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WavingHand: SkinTone1Emoji get() = _WavingHand

/**
 * Alias to emoji [WavingHand] (People & Body: hand-fingers-open: waving hand).
*/
public val Emoji.Companion.Wave: SkinTone1Emoji get() = _WavingHand
