package org.kodein.emoji.people_body.person_resting

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonInLotusPosition: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧘",
        description = "person in lotus position",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("person-in-lotus-position", "yoga", "meditation", "lotus-position"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-resting: person in lotus position.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonInLotusPosition: SkinTone1Emoji get() = _PersonInLotusPosition

/**
 * Alias to emoji [PersonInLotusPosition] (People & Body: person-resting: person in lotus position).
*/
public val Emoji.Companion.Yoga: SkinTone1Emoji get() = _PersonInLotusPosition

/**
 * Alias to emoji [PersonInLotusPosition] (People & Body: person-resting: person in lotus position).
*/
public val Emoji.Companion.Meditation: SkinTone1Emoji get() = _PersonInLotusPosition

/**
 * Alias to emoji [PersonInLotusPosition] (People & Body: person-resting: person in lotus position).
*/
public val Emoji.Companion.LotusPosition: SkinTone1Emoji get() = _PersonInLotusPosition
