package org.kodein.emoji.people_body.person_resting

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonTakingBath: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🛀",
        description = "person taking bath",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-taking-bath", "bathe"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-resting: person taking bath.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonTakingBath: SkinTone1Emoji get() = _PersonTakingBath

/**
 * Alias to emoji [PersonTakingBath] (People & Body: person-resting: person taking bath).
*/
public val Emoji.Companion.Bathe: SkinTone1Emoji get() = _PersonTakingBath
