package org.kodein.emoji.smileys_emotion.face_affection

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmilingFaceWithHeartEyes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😍",
        description = "smiling face with heart-eyes",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("smiling-face-with-heart-eyes", "heart-eyes"),
        emoticons = listOf("♥_♥"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-affection: smiling face with heart-eyes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmilingFaceWithHeartEyes: Emoji get() = _SmilingFaceWithHeartEyes

/**
 * Alias to emoji [SmilingFaceWithHeartEyes] (Smileys & Emotion: face-affection: smiling face with heart-eyes).
*/
public val Emoji.Companion.HeartEyes: Emoji get() = _SmilingFaceWithHeartEyes
