package org.kodein.emoji.smileys_emotion.face_unwell

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithMedicalMask: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😷",
        description = "face with medical mask",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("face-with-medical-mask", "mask"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-unwell: face with medical mask.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithMedicalMask: Emoji get() = _FaceWithMedicalMask

/**
 * Alias to emoji [FaceWithMedicalMask] (Smileys & Emotion: face-unwell: face with medical mask).
*/
public val Emoji.Companion.Mask: Emoji get() = _FaceWithMedicalMask
