package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseHereButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈁",
        description = "Japanese “here” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-here-button", "here"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “here” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseHereButton: Emoji get() = _JapaneseHereButton

/**
 * Alias to emoji [JapaneseHereButton] (Symbols: alphanum: Japanese “here” button).
*/
public val Emoji.Companion.Here: Emoji get() = _JapaneseHereButton
