package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OButtonBloodType: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🅾️",
        description = "O button (blood type)",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("o-button-blood-type-", "o-button", "blood-type-o"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: O button (blood type).
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OButtonBloodType: Emoji get() = _OButtonBloodType

/**
 * Alias to emoji [OButtonBloodType] (Symbols: alphanum: O button (blood type)).
*/
public val Emoji.Companion.OButton: Emoji get() = _OButtonBloodType

/**
 * Alias to emoji [OButtonBloodType] (Symbols: alphanum: O button (blood type)).
*/
public val Emoji.Companion.BloodTypeO: Emoji get() = _OButtonBloodType
