package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LastQuarterMoonFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌜",
        description = "last quarter moon face",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("last-quarter-moon-face", "moon-face-last-quarter"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: last quarter moon face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LastQuarterMoonFace: Emoji get() = _LastQuarterMoonFace

/**
 * Alias to emoji [LastQuarterMoonFace] (Travel & Places: sky & weather: last quarter moon face).
*/
public val Emoji.Companion.MoonFaceLastQuarter: Emoji get() = _LastQuarterMoonFace
