package org.kodein.emoji.activities

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.activities.event.*
import org.kodein.emoji.activities.award_medal.*
import org.kodein.emoji.activities.sport.*
import org.kodein.emoji.activities.game.*
import org.kodein.emoji.activities.arts_crafts.*


internal fun EmojiFinder.addAllActivities() {
    addAllEvent()
    addAllAwardMedal()
    addAllSport()
    addAllGame()
    addAllArtsCrafts()
}

internal suspend fun SequenceScope<Emoji>.yieldAllActivities() {
    yieldAllEvent()
    yieldAllAwardMedal()
    yieldAllSport()
    yieldAllGame()
    yieldAllArtsCrafts()
}

internal val countActivities = 85

/**
 * All Emoji of the Activities group.
*/
public fun Emoji.Companion.sequenceActivities(): Sequence<Emoji> =
    sequence { yieldAllActivities() }

/**
 * All Emoji of the Activities group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allActivities(): List<Emoji> =
    ArrayList<Emoji>(countActivities).also { list -> sequenceActivities().forEach { list.add(it) } }

internal fun allActivitiesSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "event" to { Emoji.listEvent() },
        "award_medal" to { Emoji.listAwardMedal() },
        "sport" to { Emoji.listSport() },
        "game" to { Emoji.listGame() },
        "arts_crafts" to { Emoji.listArtsCrafts() },
    )
