package org.kodein.emoji.activities.arts_crafts

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PerformingArts: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎭",
        description = "performing arts",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("performing-arts", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: arts & crafts: performing arts.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PerformingArts: Emoji get() = _PerformingArts
