package org.kodein.emoji.activities.event

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PineDecoration: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎍",
        description = "pine decoration",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("pine-decoration", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: event: pine decoration.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PineDecoration: Emoji get() = _PineDecoration
