package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HeartSuit: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♥️",
        description = "heart suit",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("heart-suit", "heart"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: game: heart suit.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HeartSuit: Emoji get() = _HeartSuit

/**
 * Alias to emoji [HeartSuit] (Activities: game: heart suit).
*/
public val Emoji.Companion.Heart: Emoji get() = _HeartSuit
