package org.kodein.emoji.activities.sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllSport() {
    add(intArrayOf(0x26bd), _SoccerBall)
    add(intArrayOf(0x26be), _Baseball)
    add(intArrayOf(0x1f94e), _Softball)
    add(intArrayOf(0x1f3c0), _Basketball)
    add(intArrayOf(0x1f3d0), _Volleyball)
    add(intArrayOf(0x1f3c8), _AmericanFootball)
    add(intArrayOf(0x1f3c9), _RugbyFootball)
    add(intArrayOf(0x1f3be), _Tennis)
    add(intArrayOf(0x1f94f), _FlyingDisc)
    add(intArrayOf(0x1f3b3), _Bowling)
    add(intArrayOf(0x1f3cf), _CricketGame)
    add(intArrayOf(0x1f3d1), _FieldHockey)
    add(intArrayOf(0x1f3d2), _IceHockey)
    add(intArrayOf(0x1f94d), _Lacrosse)
    add(intArrayOf(0x1f3d3), _PingPong)
    add(intArrayOf(0x1f3f8), _Badminton)
    add(intArrayOf(0x1f94a), _BoxingGlove)
    add(intArrayOf(0x1f94b), _MartialArtsUniform)
    add(intArrayOf(0x1f945), _GoalNet)
    add(intArrayOf(0x26f3), _FlagInHole)
    add(intArrayOf(0x26f8, 0xfe0f), _IceSkate)
    add(intArrayOf(0x26f8), _IceSkate)
    add(intArrayOf(0x1f3a3), _FishingPole)
    add(intArrayOf(0x1f93f), _DivingMask)
    add(intArrayOf(0x1f3bd), _RunningShirt)
    add(intArrayOf(0x1f3bf), _Skis)
    add(intArrayOf(0x1f6f7), _Sled)
    add(intArrayOf(0x1f94c), _CurlingStone)
}

internal suspend fun SequenceScope<Emoji>.yieldAllSport() {
    yield(_SoccerBall)
    yield(_Baseball)
    yield(_Softball)
    yield(_Basketball)
    yield(_Volleyball)
    yield(_AmericanFootball)
    yield(_RugbyFootball)
    yield(_Tennis)
    yield(_FlyingDisc)
    yield(_Bowling)
    yield(_CricketGame)
    yield(_FieldHockey)
    yield(_IceHockey)
    yield(_Lacrosse)
    yield(_PingPong)
    yield(_Badminton)
    yield(_BoxingGlove)
    yield(_MartialArtsUniform)
    yield(_GoalNet)
    yield(_FlagInHole)
    yield(_IceSkate)
    yield(_FishingPole)
    yield(_DivingMask)
    yield(_RunningShirt)
    yield(_Skis)
    yield(_Sled)
    yield(_CurlingStone)
}

internal val countSport = 27

/**
 * All Emoji of the Activities: sport subgroup.
*/
public fun Emoji.Companion.sequenceSport(): Sequence<Emoji> =
    sequence { yieldAllSport() }

/**
 * All Emoji of the Activities: sport subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listSport(): List<Emoji> =
    ArrayList<Emoji>(countSport).also { list -> sequenceSport().forEach { list.add(it) } }

@Deprecated("Renamed listSport.", replaceWith = ReplaceWith("listSport()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allSport(): List<Emoji> =
    listSport()
