package org.kodein.emoji.animals_nature.animal_bird

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAnimalBird() {
    add(intArrayOf(0x1f983), _Turkey)
    add(intArrayOf(0x1f414), _Chicken)
    add(intArrayOf(0x1f413), _Rooster)
    add(intArrayOf(0x1f423), _HatchingChick)
    add(intArrayOf(0x1f424), _BabyChick)
    add(intArrayOf(0x1f425), _FrontFacingBabyChick)
    add(intArrayOf(0x1f426), _Bird)
    add(intArrayOf(0x1f427), _Penguin)
    add(intArrayOf(0x1f54a, 0xfe0f), _Dove)
    add(intArrayOf(0x1f54a), _Dove)
    add(intArrayOf(0x1f985), _Eagle)
    add(intArrayOf(0x1f986), _Duck)
    add(intArrayOf(0x1f9a2), _Swan)
    add(intArrayOf(0x1f989), _Owl)
    add(intArrayOf(0x1f9a4), _Dodo)
    add(intArrayOf(0x1fab6), _Feather)
    add(intArrayOf(0x1f9a9), _Flamingo)
    add(intArrayOf(0x1f99a), _Peacock)
    add(intArrayOf(0x1f99c), _Parrot)
    add(intArrayOf(0x1fabd), _Wing)
    add(intArrayOf(0x1f426, 0x200d, 0x2b1b), _BlackBird)
    add(intArrayOf(0x1fabf), _Goose)
    add(intArrayOf(0x1f426, 0x200d, 0x1f525), _Phoenix)
}

internal suspend fun SequenceScope<Emoji>.yieldAllAnimalBird() {
    yield(_Turkey)
    yield(_Chicken)
    yield(_Rooster)
    yield(_HatchingChick)
    yield(_BabyChick)
    yield(_FrontFacingBabyChick)
    yield(_Bird)
    yield(_Penguin)
    yield(_Dove)
    yield(_Eagle)
    yield(_Duck)
    yield(_Swan)
    yield(_Owl)
    yield(_Dodo)
    yield(_Feather)
    yield(_Flamingo)
    yield(_Peacock)
    yield(_Parrot)
    yield(_Wing)
    yield(_BlackBird)
    yield(_Goose)
    yield(_Phoenix)
}

internal val countAnimalBird = 22

/**
 * All Emoji of the Animals & Nature: animal-bird subgroup.
*/
public fun Emoji.Companion.sequenceAnimalBird(): Sequence<Emoji> =
    sequence { yieldAllAnimalBird() }

/**
 * All Emoji of the Animals & Nature: animal-bird subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listAnimalBird(): List<Emoji> =
    ArrayList<Emoji>(countAnimalBird).also { list -> sequenceAnimalBird().forEach { list.add(it) } }

@Deprecated("Renamed listAnimalBird.", replaceWith = ReplaceWith("listAnimalBird()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allAnimalBird(): List<Emoji> =
    listAnimalBird()
