package org.kodein.emoji.animals_nature.animal_mammal

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Bear: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🐻",
        description = "bear",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("bear", "bear-face"),
        emoticons = listOf("ʕ·ᴥ·ʔ"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Animals & Nature: animal-mammal: bear.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Bear: Emoji get() = _Bear

/**
 * Alias to emoji [Bear] (Animals & Nature: animal-mammal: bear).
*/
public val Emoji.Companion.BearFace: Emoji get() = _Bear
