package org.kodein.emoji.animals_nature.animal_marine

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Whale: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🐋",
        description = "whale",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("whale", "humpback-whale"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Animals & Nature: animal-marine: whale.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Whale: Emoji get() = _Whale

/**
 * Alias to emoji [Whale] (Animals & Nature: animal-marine: whale).
*/
public val Emoji.Companion.HumpbackWhale: Emoji get() = _Whale
