package org.kodein.emoji.animals_nature.plant_other

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SheafOfRice: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌾",
        description = "sheaf of rice",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("sheaf-of-rice", "ear-of-rice"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Animals & Nature: plant-other: sheaf of rice.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SheafOfRice: Emoji get() = _SheafOfRice

/**
 * Alias to emoji [SheafOfRice] (Animals & Nature: plant-other: sheaf of rice).
*/
public val Emoji.Companion.EarOfRice: Emoji get() = _SheafOfRice
