package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAlbania: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇱",
        description = "flag: Albania",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-albania", "albania-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.4f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Albania.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAlbania: Emoji get() = _FlagAlbania

/**
 * Alias to emoji [FlagAlbania] (Flags: country-flag: flag: Albania).
*/
public val Emoji.Companion.AlbaniaFlag: Emoji get() = _FlagAlbania
