package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAntiguaBarbuda: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇬",
        description = "flag: Antigua & Barbuda",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-antigua-barbuda", "antigua-barbuda-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Antigua & Barbuda.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAntiguaBarbuda: Emoji get() = _FlagAntiguaBarbuda

/**
 * Alias to emoji [FlagAntiguaBarbuda] (Flags: country-flag: flag: Antigua & Barbuda).
*/
public val Emoji.Companion.AntiguaBarbudaFlag: Emoji get() = _FlagAntiguaBarbuda
