package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBarbados: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇧",
        description = "flag: Barbados",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-barbados", "barbados-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Barbados.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBarbados: Emoji get() = _FlagBarbados

/**
 * Alias to emoji [FlagBarbados] (Flags: country-flag: flag: Barbados).
*/
public val Emoji.Companion.BarbadosFlag: Emoji get() = _FlagBarbados
